/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.filesvr;

import com.ibm.hsc.filesvr.FsByteStream;
import com.ibm.hsc.filesvr.FsConnection;
import com.ibm.hsc.filesvr.FsException;
import com.ibm.hsc.filesvr.FsFileFilter;
import com.ibm.hsc.filesvr.FsFileListPacket;
import com.ibm.hsc.filesvr.FsFileListResponsePacket;
import com.ibm.hsc.filesvr.FsPacket;
import java.util.GregorianCalendar;

public class FsFileListRequestPacket
extends FsFileListPacket {
    protected FsFileListRequestPacket(FsConnection fsConnection) {
        super(fsConnection);
        this.setRequestPacket();
    }

    protected FsFileListRequestPacket(FsConnection fsConnection, int n) {
        super(fsConnection, n);
        this.setRequestPacket();
    }

    protected FsFileListRequestPacket(FsConnection fsConnection, int n, int n2) {
        super(fsConnection, n, n2);
        this.setRequestPacket();
    }

    protected FsFileListRequestPacket(FsPacket fsPacket) {
        super(fsPacket);
        this.setRequestPacket();
    }

    protected FsFileListRequestPacket(FsPacket fsPacket, int n) {
        super(fsPacket, n);
        this.setRequestPacket();
    }

    protected FsFileListRequestPacket(FsPacket fsPacket, int n, int n2) {
        super(fsPacket, n, n2);
        this.setRequestPacket();
    }

    public FsFileListRequestPacket(FsFileListPacket fsFileListPacket) {
        super(fsFileListPacket);
        this.setRequestPacket();
    }

    public FsFileListRequestPacket(FsFileListRequestPacket fsFileListRequestPacket) {
        super(fsFileListRequestPacket);
        this.setRequestPacket();
    }

    protected void buildData(FsByteStream fsByteStream) throws FsException {
        super.buildData(fsByteStream);
        if (!this.isRequestPacket()) {
            throw new FsException(20);
        }
        if (this.m_filter.isNameSet()) {
            String string = this.m_filter.getName();
            fsByteStream.writeInt(1, 1);
            fsByteStream.writeLong(string.length(), 7);
            fsByteStream.writeString(string);
        }
        if (this.m_filter.isSizeMinimumSet()) {
            fsByteStream.writeInt(3, 1);
            fsByteStream.writeLong(this.m_filter.getSizeMinimum(), 7);
        }
        if (this.m_filter.isSizeMaximumSet()) {
            fsByteStream.writeInt(2, 1);
            fsByteStream.writeLong(this.m_filter.getSizeMaximum(), 7);
        }
        if (this.m_filter.isDateMinimumSet()) {
            fsByteStream.writeInt(5, 1);
            fsByteStream.writeDate(this.m_filter.getDateMinimum());
        }
        if (this.m_filter.isDateMaximumSet()) {
            fsByteStream.writeInt(4, 1);
            fsByteStream.writeDate(this.m_filter.getDateMaximum());
        }
    }

    public GregorianCalendar getFileDateMaximum() {
        return this.m_filter.getDateMaximum();
    }

    public GregorianCalendar getFileDateMinimum() {
        return this.m_filter.getDateMinimum();
    }

    public FsFileFilter getFileFilter() {
        return this.m_filter;
    }

    public String getFileName() {
        return this.m_filter.getName();
    }

    public long getFileSizeMaximum() {
        return this.m_filter.getSizeMaximum();
    }

    public long getFileSizeMinimum() {
        return this.m_filter.getSizeMinimum();
    }

    public FsPacket getResponsePacket() {
        return new FsFileListResponsePacket(this);
    }

    protected void parseData(FsByteStream fsByteStream) throws FsException {
        super.parseData(fsByteStream);
        if (!this.isRequestPacket()) {
            throw new FsException(20);
        }
        block7: while (8 <= fsByteStream.available()) {
            byte by = fsByteStream.readByte();
            switch (by) {
                case 1: {
                    int n = (int)fsByteStream.readLong(7);
                    this.m_filter.setName(fsByteStream.readString(n));
                    continue block7;
                }
                case 3: {
                    this.m_filter.setSizeMinimum(fsByteStream.readLong(7));
                    continue block7;
                }
                case 2: {
                    this.m_filter.setSizeMaximum(fsByteStream.readLong(7));
                    continue block7;
                }
                case 5: {
                    this.m_filter.setDateMinimum(fsByteStream.readDate());
                    continue block7;
                }
                case 4: {
                    this.m_filter.setDateMaximum(fsByteStream.readDate());
                    continue block7;
                }
            }
            throw new FsException(25, by);
        }
    }

    public void setFileDateMaximum(GregorianCalendar gregorianCalendar) {
        this.m_filter.setDateMaximum(gregorianCalendar);
    }

    public void setFileDateMaximum(int n, int n2, int n3) {
        this.m_filter.setDateMaximum(new GregorianCalendar(n, n2 - 1, n3));
    }

    public void setFileDateMaximum(int n, int n2, int n3, int n4, int n5) {
        this.m_filter.setDateMaximum(new GregorianCalendar(n, n2 - 1, n3, n4, n5));
    }

    public void setFileDateMaximum(int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_filter.setDateMaximum(new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6));
    }

    public void setFileDateMinimum(GregorianCalendar gregorianCalendar) {
        this.m_filter.setDateMinimum(gregorianCalendar);
    }

    public void setFileDateMinimum(int n, int n2, int n3) {
        this.m_filter.setDateMinimum(new GregorianCalendar(n, n2 - 1, n3));
    }

    public void setFileDateMinimum(int n, int n2, int n3, int n4, int n5) {
        this.m_filter.setDateMinimum(new GregorianCalendar(n, n2 - 1, n3, n4, n5));
    }

    public void setFileDateMinimum(int n, int n2, int n3, int n4, int n5, int n6) {
        this.m_filter.setDateMinimum(new GregorianCalendar(n, n2 - 1, n3, n4, n5, n6));
    }

    public void setFileName(String string) {
        this.m_filter.setName(string);
    }

    public void setFileSizeMaximum(long l) {
        this.m_filter.setSizeMaximum(l);
    }

    public void setFileSizeMinimum(long l) {
        this.m_filter.setSizeMinimum(l);
    }
}

